% SPLITTRNTST Divides the rss measurements data into a training set and a
% test set accoding to a specific configuration.
%
%	[TRNDATA,TSTDATA] = SPLITTRNTST(DATA, CONFIGURATION) splits DATA into
%	TRNDATA and TSTDATA, according to CONFIGURATION.
%
%   See Also GETFILTERDEFS.
%
%   Copyright  2018 Universitat Jaume I (UJI)

% Permission is hereby granted, free of charge, to any person obtaining a copy of
% this software and associated documentation files (the "Software"), to deal in
% the Software without restriction, including without limitation the rights to
% use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
% of the Software, and to permit persons to whom the Software is furnished to do
% so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all
% copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
% OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
% SOFTWARE.

function [rssTrnMat,rssTstMat,coorTrnMat,coorTstMat] = splitTrnTst_fromMatrix(set,rssMatrix,coordMatrix)

% configuration = 1 -> Propoused split (among rp)
% configuration = 0 -> Random split (among rp)
c = cvpartition(size(rssMatrix,1),'HoldOut',0.02);

% Output matrix are crated
rssTrnMat = zeros(sum(training(c)),size(rssMatrix,2));
rssTstMat = zeros(sum(test(c)),size(rssMatrix,2));
coorTrnMat = zeros(sum(training(c)),3);
coorTstMat = zeros(sum(test(c)),3);

% Original matrix is divided into test and traning matrix
rssTrnMat =  rssMatrix(logical(training(c)),:);
rssTstMat =  rssMatrix(logical(test(c)),:);
coorTrnMat = coordMatrix(logical(training(c)),:);
coorTstMat = coordMatrix(logical(test(c)),:);
end

